<?php
// Start output buffering
ob_start();

// Enable error reporting
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$env_file_path = realpath(__DIR__."/owners/.env");


// Function to read the .env file and load the variables
function loadEnv($file) {
    if (!file_exists($file)) {
        throw new Exception(".env file not found");
    }

    $lines = file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        // Skip comments
        if (strpos(trim($line), '#') === 0) {
            continue;
        }

        // Parse the line to get the key and value
        list($key, $value) = explode('=', $line, 2);

        // Remove any quotes and trim spaces
        $key = trim($key);
        $value = trim($value, " \"'");

        // Define the environment variable
        putenv("$key=$value");
    }
}

// Load .env file
loadEnv($env_file_path);

$dbHost = getenv('DB_HOST');
$dbName = getenv('DB_DATABASE');
$dbUser = getenv('DB_USERNAME');
$dbPass = getenv('DB_PASSWORD');
$websiteUrl = str_replace('/owners','',getenv('ASSET_URL'));

try {
    // Create a PDO instance
    $pdo = new PDO("mysql:host=$dbHost;dbname=$dbName", $dbUser, $dbPass);
    
    // Set PDO to throw exceptions on error
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Function to execute a generic query
    function executeQuery($pdo, $query, $params = array()) {
        $stmt = $pdo->prepare($query);
        $stmt->execute($params);
        return $stmt;
    }
} catch (PDOException $e) {
    // Handle database connection error
   echo "Connection failed: " . $e->getMessage();
}

function createURL($url){
    return urlencode($url);
}


